package ru.yandex.webmaster3.core.logbroker.reader;

import java.util.List;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * ishalaru
 * 19.12.2019
 **/
@Slf4j
@Component
//@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class LogbrokerStreamConsumerStateWatcher {
    private final List<LogbrokerStreamConsumerBuilder> list;

    @Autowired(required = false)
    public LogbrokerStreamConsumerStateWatcher(List<LogbrokerStreamConsumerBuilder> list) {
        this.list = list;
    }

    @Scheduled(fixedDelay = 30000, initialDelay = 20000)
    public void run() {
        if (list != null) {
            log.info("Run watcher.");
            for (LogbrokerStreamConsumerBuilder logbrokerStreamConsumerBuilder : list) {
                try {
                    logbrokerStreamConsumerBuilder.checkConnectionState();
                } catch (Exception exp) {
                    log.error(exp.getMessage(), exp);
                }
            }
        }
    }

}
