package ru.yandex.webmaster3.core.logbroker.writer;

import lombok.RequiredArgsConstructor;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

/**
 * ishalaru
 * 10.06.2021
 **/
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class LogbrokerClientFactor extends BasePooledObjectFactory<LogbrokerWriter> {
    private final ApplicationContext applicationContext;
    private final String beanName;

    @Override
    public LogbrokerWriter create() throws Exception {
        return applicationContext.getBean(beanName, LogbrokerWriter.class);
    }

    @Override
    public PooledObject<LogbrokerWriter> wrap(LogbrokerWriter obj) {
        return new DefaultPooledObject<>(obj);
    }
}
