package ru.yandex.webmaster3.core.metrics;

import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author aherman
 */
public class JVMMetricsRegistrar implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(JVMMetricsRegistrar.class);

    private final SolomonMicrometerMeterRegistry solomonMicrometerMeterRegistry;

    @Autowired
    public JVMMetricsRegistrar(SolomonMicrometerMeterRegistry solomonMicrometerMeterRegistry) {
        this.solomonMicrometerMeterRegistry = solomonMicrometerMeterRegistry;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        log.info("Register JVM metrics");

        new JvmGcMetrics().bindTo(solomonMicrometerMeterRegistry);
        new JvmMemoryMetrics().bindTo(solomonMicrometerMeterRegistry);
        new JvmThreadMetrics().bindTo(solomonMicrometerMeterRegistry);

        new LogbackMetrics().bindTo(solomonMicrometerMeterRegistry);

        new ProcessorMetrics().bindTo(solomonMicrometerMeterRegistry);
        new UptimeMetrics().bindTo(solomonMicrometerMeterRegistry);
    }
}
