package ru.yandex.webmaster3.core.metrics.externals;

import org.springframework.core.annotation.AnnotationUtils;
import ru.yandex.webmaster3.core.util.JavaMethodWitness;

import java.lang.reflect.Method;

/**
 * @author avhaliullin
 */
class ExternalDependencyUtils {
    static String getMethodName(Method method) {
        ExternalDependencyMethod annotation = AnnotationUtils.findAnnotation(method, ExternalDependencyMethod.class);
        return annotation == null ? null : annotation.value();
    }

    static String getMethodName(JavaMethodWitness method) {
        return method.getEnclosingMethod().map(ExternalDependencyUtils::getMethodName).orElse(null);
    }
}
