package ru.yandex.webmaster3.core.metrika.counters;

import lombok.ToString;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/**
 * @author leonidrom
 */
@ToString
public class AnonymousCounterBinding {
    public static final String ORIGIN_METRIKA = "metrika";
    public static final String ORIGIN_WEBMASTER = "webmaster";
    public static final String ORIGIN_FAKE = "fake";

    protected final String domain;
    protected final long counterId;
    protected final CounterBindingStateEnum counterBindingState;
    protected final DateTime updateDate;

    @Nullable
    protected final String origin;

    public AnonymousCounterBinding(String domain, long counterId, CounterBindingStateEnum counterBindingState,
                          DateTime updateDate, @Nullable String origin) {
        this.domain = domain;
        this.counterId = counterId;
        this.counterBindingState = counterBindingState;
        this.updateDate = updateDate;
        this.origin = origin;
    }

    public String getDomain() {
        return domain;
    }

    public long getCounterId() {
        return counterId;
    }

    public CounterBindingStateEnum getCounterBindingState() {
        return counterBindingState;
    }

    public DateTime getUpdateDate() {
        return updateDate;
    }

    @Nullable
    public String getOrigin() {
        return origin;
    }

    /**
     *  Фейковые счетчики используются для тестирования. Метрика про них ничего не знает.
     */
    public boolean isFake() {
        return ORIGIN_FAKE.equals(origin);
    }
}
