package ru.yandex.webmaster3.core.metrika.counters;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * Created by ifilippov5 on 24.10.17.
 */
public enum CounterActionTypeEnum implements IntEnum {
    M_REQUEST(0),
    M_REJECT(1),
    W_REQUEST(2),
    W_REJECT(3),;

    private final int value;

    CounterActionTypeEnum(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<CounterActionTypeEnum> R = IntEnumResolver.r(CounterActionTypeEnum.class);
}
