package ru.yandex.webmaster3.core.metrika.counters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.ToString;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Created by ifilippov5 on 27.11.17.
 */
@ToString(callSuper=true)
public class CounterBinding extends AnonymousCounterBinding {
    private final Long webmasterUserId;
    private final String lastUserLogin;
    private final Long metrikaUserId;

    @JsonCreator
    public CounterBinding(String domain, long counterId, CounterBindingStateEnum counterBindingState,
                          @Nullable Long userId, String userLogin, DateTime updateDate, @Nullable Long metrikaUserId,
                          @Nullable String origin) {
        super(domain, counterId, counterBindingState, updateDate, origin);

        this.webmasterUserId = userId;
        this.lastUserLogin = userLogin;
        this.metrikaUserId = metrikaUserId;
    }

    @Nullable
    public Long getWebmasterUserId() {
        return webmasterUserId;
    }

    public String getLastUserLogin() {
        return lastUserLogin;
    }

    @Nullable
    public Long getMetrikaUserId() {
        return metrikaUserId;
    }
}
