package ru.yandex.webmaster3.core.metrika.counters;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * Created by ifilippov5 on 24.10.17.
 */
public enum CounterBindingStateEnum implements IntEnum {
    NONE(0, "deleted", false, false),
    METRIKA_REQUEST(1, "need_webmaster_confirm", false, true),
    WEBMASTER_REQUEST(2, "need_metrika_confirm", true, false),
    APPROVED(3, "ok", true, true),
    METRIKA_REJECT(4, "deleted", true, false),
    ;

    private final int value;
    private final String meaning;
    private final boolean webmasterApproved;
    private final boolean metrikaApproved;

    CounterBindingStateEnum(int value, String meaning, boolean webmasterApproved, boolean metrikaApproved) {
        this.value = value;
        this.meaning = meaning;
        this.webmasterApproved = webmasterApproved;
        this.metrikaApproved = metrikaApproved;
    }

    public boolean isWebmasterApproved() {
        return webmasterApproved;
    }

    public boolean isMetrikaApproved() {
        return metrikaApproved;
    }

    public boolean isApproved() {
        return this == APPROVED;
    }

    public int getValue() {
        return value;
    }

    public String getMeaning() {
        return meaning;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<CounterBindingStateEnum> R = IntEnumResolver.r(CounterBindingStateEnum.class);
}
