package ru.yandex.webmaster3.core.metrika.counters;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * Created by ifilippov5 on 27.11.17.
 */
public class CounterInfo {
    private final long counterId;
    private final String counterName;
    private final String counterSite;
    private final CounterStatusEnum status;
    private final String ownerLogin;

    @JsonCreator
    public CounterInfo(long counterId, String counterName, String counterSite, CounterStatusEnum status, String ownerLogin) {
        this.counterId = counterId;
        this.counterName = counterName;
        this.counterSite = counterSite;
        this.status = status;
        this.ownerLogin = ownerLogin;
    }

    public long getCounterId() {
        return counterId;
    }

    public String getCounterName() {
        return counterName;
    }

    public String getCounterSite() {
        return counterSite;
    }

    public CounterStatusEnum getStatus() {
        return status;
    }

    public String getOwnerLogin() {
        return ownerLogin;
    }

    public CounterInfo withCounterName(String counterName) {
        return new CounterInfo(counterId, counterName, counterSite, status, ownerLogin);
    }

    public static CounterInfo newFakeCounterInfo(long counterId) {
        return new CounterInfo(counterId, "fake_" + counterId, null, CounterStatusEnum.ACTIVE, null);
    }

    public enum CounterStatusEnum {
        ACTIVE,
        DELETED
        ;

        public static EnumResolver<CounterStatusEnum> R = EnumResolver.er(CounterStatusEnum.class);
    }
}
