package ru.yandex.webmaster3.core.metrika.counters;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.joda.time.LocalDate;
import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * Created by ifilippov5 on 30.11.17.
 */
public class MetrikaCounterBindingInfo {
    private final long counterId;
    private final String counterName;
    private final String counterSite;
    @Description("Логин пользователя - автора последнего изменения")
    private final String userLogin;
    private final LocalDate updateDate;
    private final CounterBindingStateEnum state;

    @JsonCreator
    public MetrikaCounterBindingInfo(long counterId, String counterName, String counterSite, String userLogin,
                                     LocalDate updateDate, CounterBindingStateEnum state) {
        this.counterId = counterId;
        this.counterName = counterName;
        this.counterSite = counterSite;
        this.userLogin = userLogin;
        this.updateDate = updateDate;
        this.state = state;
    }

    public long getCounterId() {
        return counterId;
    }

    public String getCounterName() {
        return counterName;
    }

    public String getCounterSite() {
        return counterSite;
    }

    public String getUserLogin() {
        return userLogin;
    }

    public LocalDate getUpdateDate() {
        return updateDate;
    }

    public CounterBindingStateEnum getState() {
        return state;
    }
}
