package ru.yandex.webmaster3.core.metrika.radar;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;

import java.util.UUID;

/**
 * Created by ifilippov5 on 10.05.18.
 */
public class ConfirmationMetricaAppIdTaskData extends WorkerTaskData {
    private final long appId;
    private final long userId;
    private final String email;

    public ConfirmationMetricaAppIdTaskData(
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("appId") long appId,
            @JsonProperty("userId") long userId,
            @JsonProperty("email") String email) {
        super(taskId, hostId);
        this.appId = appId;
        this.userId = userId;
        this.email = email;
    }

    public ConfirmationMetricaAppIdTaskData(WebmasterHostId hostId, long appId, long userId, String email) {
        super(hostId);
        this.appId = appId;
        this.userId = userId;
        this.email = email;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.CONFIRMATION_METRICA_APP_ID;
    }

    @Override
    public String getShortDescription() {
        return "Confirmation binding host with metrica app";
    }

    public long getAppId() {
        return appId;
    }

    public long getUserId() {
        return userId;
    }

    public String getEmail() {
        return email;
    }
}
