package ru.yandex.webmaster3.core.metrika.radar;

import org.joda.time.DateTime;

/**
 * Created by ifilippov5 on 08.05.18.
 */
public class HostMetricaAppIdState {
    private final String hostUrl;
    private final long appId;
    private final MetricaAppIdBindingStateEnum bindingState;
    private final String userLogin;
    private final String email;
    private final DateTime addTime;
    private final DateTime lastUpdate;

    public HostMetricaAppIdState(String hostUrl, long appId, MetricaAppIdBindingStateEnum bindingState,
                                 String userLogin, String email, DateTime addTime, DateTime lastUpdate) {
        this.hostUrl = hostUrl;
        this.appId = appId;
        this.bindingState = bindingState;
        this.userLogin = userLogin;
        this.email = email;
        this.addTime = addTime;
        this.lastUpdate = lastUpdate;
    }

    public String getHostUrl() {
        return hostUrl;
    }

    public long getAppId() {
        return appId;
    }

    public MetricaAppIdBindingStateEnum getBindingState() {
        return bindingState;
    }

    public String getUserLogin() {
        return userLogin;
    }

    public String getEmail() {
        return email;
    }

    public DateTime getAddTime() {
        return addTime;
    }

    public DateTime getLastUpdate() {
        return lastUpdate;
    }

    public static HostMetricaAppIdState create(HostMetricaAppIdState state, MetricaAppIdBindingStateEnum newBindingState) {
        return new HostMetricaAppIdState(state.getHostUrl(), state.getAppId(), newBindingState, state.getUserLogin(),
                state.getEmail(), state.getAddTime(), state.getLastUpdate());
    }
}
