package ru.yandex.webmaster3.core.nanny.alemate;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.Instant;

/**
 * @author avhaliullin
 */
public class NannyTaskgroupInfo {
    private final String taskgroupId;
    private final NannyTaskgroupStatusEnum status;
    private final String statusString;
    private final Instant creationTimestamp;
    private final Instant finishTimestamp;
    private final String nannyServiceId;
    private final String description;
    private final String author;
    private final String queue;
    private final String nannyTicketId;

    public NannyTaskgroupInfo(
            @JsonProperty("id") String taskgroupId,
            @JsonProperty("status") String statusString,
            @JsonProperty("creation_timestamp") Instant creationTimestamp,
            @JsonProperty("finish_timestamp") Instant finishTimestamp,
            @JsonProperty("nanny_service_id") String nannyServiceId,
            @JsonProperty("description") String description,
            @JsonProperty("author") String author,
            @JsonProperty("queue") String queue,
            @JsonProperty("nanny_ticket_id") String nannyTicketId
    ) {
        this.taskgroupId = taskgroupId;
        this.statusString = statusString;
        this.status = NannyTaskgroupStatusEnum.R.valueOfOrNull(statusString);
        this.creationTimestamp = creationTimestamp;
        this.finishTimestamp = finishTimestamp;
        this.nannyServiceId = nannyServiceId;
        this.description = description;
        this.author = author;
        this.queue = queue;
        this.nannyTicketId = nannyTicketId;
    }

    public String getTaskgroupId() {
        return taskgroupId;
    }

    public NannyTaskgroupStatusEnum getStatus() {
        return status;
    }

    public String getStatusString() {
        return statusString;
    }

    public Instant getCreationTimestamp() {
        return creationTimestamp;
    }

    public Instant getFinishTimestamp() {
        return finishTimestamp;
    }

    public String getNannyServiceId() {
        return nannyServiceId;
    }

    public String getDescription() {
        return description;
    }

    public String getAuthor() {
        return author;
    }

    public String getQueue() {
        return queue;
    }

    public String getNannyTicketId() {
        return nannyTicketId;
    }
}
