package ru.yandex.webmaster3.core.nanny.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import org.joda.time.Instant;

import java.io.IOException;

/**
 * @author avhaliullin
 */
public class InstantSecondsDeserializer extends StdScalarDeserializer<Instant> {
    private static final long serialVersionUID = 1L;

    public InstantSecondsDeserializer() {
        super(Instant.class);
    }

    @Override
    public Instant deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Instant(jp.getLongValue() * 1000);
        }
        throw ctxt.mappingException(Instant.class);
    }
}
