package ru.yandex.webmaster3.core.nanny.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.joda.time.Instant;

/**
 * @author avhaliullin
 */
public class NannyJsonUtil {
    public static final ObjectMapper OM = new ObjectMapper()
            .registerModule(new NannyModule())
            .disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

    private static class NannyModule extends SimpleModule {
        NannyModule() {
            addDeserializer(Instant.class, new InstantSecondsDeserializer());
        }
    }
}
