package ru.yandex.webmaster3.core.notification;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.core.data.L10nEnum;

/**
 * Язык локализации
 *
 * User: azakharov
 * Date: 17.05.12
 * Time: 17:43
 */
public enum LanguageEnum implements IntEnum {
    RU("ru", 0, L10nEnum.RU),
    UK("uk", 1, L10nEnum.UK),
    EN("en", 2, L10nEnum.EN),
    TR("tr", 3, L10nEnum.TR),
    ;

    public static final LanguageEnum DEFAULT_EMAIL_LANGUAGE = RU;

    private final String name;
    private final int id;
    private final L10nEnum l10n;

    private LanguageEnum(String name, int id, L10nEnum l10n) {
        this.name = name;
        this.id = id;
        this.l10n = l10n;
    }

    public String getName() {
        return name;
    }

    public int getId() {
        return id;
    }

    @Override
    public int value() {
        return id;
    }

    public L10nEnum getL10n() {
        return l10n;
    }

    public static LanguageEnum fromString(String value) {
        for (LanguageEnum lang : values()) {
            if (lang.name.equalsIgnoreCase(value)) {
                return lang;
            }
        }

        return null;
    }

    public static final IntEnumResolver<LanguageEnum> R = IntEnumResolver.r(LanguageEnum.class);
}
