package ru.yandex.webmaster3.core.partner;

/**
 * Created by Oleg Bazdyrev on 03/07/2018.
 * Предсказание дохода для одного домена
 */
public class PartnerDomainPrediction {

    private final String domain;
    private final boolean monetizedYandex;
    private final boolean monetizedCompetitors1;
    private final boolean monetizedCompetitors2;
    private final long roundMonthReward;
    private final String category;

    public PartnerDomainPrediction(String domain, boolean monetizedYandex, boolean monetizedCompetitors1,
                                   boolean monetizedCompetitors2, long roundMonthReward, String category) {
        this.domain = domain;
        this.monetizedYandex = monetizedYandex;
        this.monetizedCompetitors1 = monetizedCompetitors1;
        this.monetizedCompetitors2 = monetizedCompetitors2;
        this.roundMonthReward = roundMonthReward;
        this.category = category;
    }

    public String getDomain() {
        return domain;
    }

    public boolean isMonetizedYandex() {
        return monetizedYandex;
    }

    public boolean isMonetizedCompetitors1() {
        return monetizedCompetitors1;
    }

    public boolean isMonetizedCompetitors2() {
        return monetizedCompetitors2;
    }

    public long getRoundMonthReward() {
        return roundMonthReward;
    }

    public String getCategory() {
        return category;
    }
}
