package ru.yandex.webmaster3.core.payments;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.ObjectUtils;
import org.joda.time.DateTime;

/**
 * Created by Oleg Bazdyrev on 2019-05-29.
 */
public class ServiceMerchantInfo {

    private final long id;
    private final long serviceId;
    private final boolean active;
    private final String entityId;
    private final String description;
    private final DateTime addDate;
    private final DateTime lastUpdate;
    private final DateTime refreshDate;
    private final ServiceMerchantOrganization organization;

    @JsonCreator
    public ServiceMerchantInfo(
            @JsonProperty("id") long id,
            @JsonProperty("serviceId") long serviceId,
            @JsonProperty("active") boolean active,
            @JsonProperty("entityId") String entityId,
            @JsonProperty("description") String description,
            @JsonProperty("addDate") DateTime addDate,
            @JsonProperty("lastUpdate") DateTime lastUpdate,
            @JsonProperty("refreshDate") DateTime refreshDate,
            @JsonProperty("organization") ServiceMerchantOrganization organization) {
        this.id = id;
        this.serviceId = serviceId;
        this.active = active;
        this.entityId = entityId;
        this.description = description;
        this.addDate = addDate;
        this.lastUpdate = lastUpdate;
        this.refreshDate = ObjectUtils.firstNonNull(refreshDate, lastUpdate);
        this.organization = organization;
    }

    public long getId() {
        return id;
    }

    public long getServiceId() {
        return serviceId;
    }

    public boolean isActive() {
        return active;
    }

    public String getEntityId() {
        return entityId;
    }

    public String getDescription() {
        return description;
    }

    public DateTime getAddDate() {
        return addDate;
    }

    public DateTime getLastUpdate() {
        return lastUpdate;
    }

    public DateTime getRefreshDate() {
        return refreshDate;
    }

    public ServiceMerchantOrganization getOrganization() {
        return organization;
    }
}
