package ru.yandex.webmaster3.core.payments;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Created by Oleg Bazdyrev on 2019-06-06.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ServiceMerchantOrganization {

    private final String name;
    private final String fullName;
    private final String englishName;
    private final String type;
    private final String inn;
    private final String ogrn;
    private final String kpp;
    private final String siteUrl;
    private final String description;
    private final String scheduleText;

    @JsonCreator
    public ServiceMerchantOrganization(
            @JsonProperty("name") String name,
            @JsonProperty("fullName") String fullName,
            @JsonProperty("englishName") String englishName,
            @JsonProperty("type") String type,
            @JsonProperty("inn") String inn,
            @JsonProperty("ogrn") String ogrn,
            @JsonProperty("kpp") String kpp,
            @JsonProperty("siteUrl") String siteUrl,
            @JsonProperty("description") String description,
            @JsonProperty("scheduleText") String scheduleText) {
        this.name = name;
        this.fullName = fullName;
        this.englishName = englishName;
        this.type = type;
        this.inn = inn;
        this.ogrn = ogrn;
        this.kpp = kpp;
        this.siteUrl = siteUrl;
        this.description = description;
        this.scheduleText = scheduleText;
    }

    public String getName() {
        return name;
    }

    public String getFullName() {
        return fullName;
    }

    public String getEnglishName() {
        return englishName;
    }

    public String getType() {
        return type;
    }

    public String getInn() {
        return inn;
    }

    public String getOgrn() {
        return ogrn;
    }

    public String getKpp() {
        return kpp;
    }

    public String getSiteUrl() {
        return siteUrl;
    }

    public String getDescription() {
        return description;
    }

    public String getScheduleText() {
        return scheduleText;
    }
}

