package ru.yandex.webmaster3.core.proto.converter;

import java.util.List;
import java.util.stream.Collectors;

import NWebmaster.proto.urltree.Exported;

import ru.yandex.webmaster3.core.host.HostStatsInfo;
import ru.yandex.webmaster3.core.host.SlowUrlSampleInfo;

/**
 * @author avhaliullin
 */
public class HostStatsConverter {
    public static HostStatsInfo convertFromProto(Exported.HostStatInfo message) {
        final List<SlowUrlSampleInfo> slowUrlSamplesList = message.getSlowUrlSamplesList().stream()
                .map(HostStatsConverter::convertFromProto).collect(Collectors.toList());
        return new HostStatsInfo(
                message.hasNumOfDocs() ? message.getNumOfDocs() : null,
                message.hasNumOfDocsOnSearch() ? message.getNumOfDocsOnSearch() : null,
                message.getNumOfDocsEmptyMetaDescr(),
                message.getNumOfDocsEmptyTitle(),
                message.hasNumOfDocsHtml() ? message.getNumOfDocsHtml() : null,
                message.getNumOfDocsEncodingUnknown(),
                message.getNumOfDocsEncodingUnknown(),
                message.hasAverageFetchTime() ? message.getAverageFetchTime() : null,
                message.getSamplesEmptyMetaDescrList(),
                message.getSamplesEmptyTitleList(),
                slowUrlSamplesList
        );
    }

    public static SlowUrlSampleInfo convertFromProto(Exported.SlowUrlSample message) {
        return new SlowUrlSampleInfo(
                message.getPath(),
                message.getLastAccess(),
                message.getFetchTime()
        );
    }
}
