package ru.yandex.webmaster3.core.proto.converter;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.link.ExternalHostSqiGroup;
import ru.yandex.webmaster3.core.link.HostLinkStatistics;
import ru.yandex.webmaster3.proto.Links;

/**
 * @author aherman
 */
public class LinksProtoConverter {
    public static HostLinkStatistics convert(WebmasterHostId hostId, UUID linkGeneratuionUUID, Links.LinksInfo linksInfo,
            Instant preparatCurrentTimestamp, Instant preparatPreviousTimestamp) {
        Map<ExternalHostSqiGroup, Long> externalHostsSqi = new HashMap<>(linksInfo.getExternalHostsIksCount());
        Map<Integer, Long> internalLinksHttpCodes = new HashMap<>(linksInfo.getInternalLinksHttpCodesCount());
        Map<Integer, Long> externalLinksHttpCodes = new HashMap<>(linksInfo.getExternalLinksHttpCodesCount());
        Map<String, Long> externalLinksTldCount = new HashMap<>(linksInfo.getExternalLinksTldCountCount());
        Map<Integer, Long> externalDetailedSqiCount = new HashMap<>(linksInfo.getExternalHostsIksCountersCount());

        for (Links.HostIksInfo hostIksInfo : linksInfo.getExternalHostsIksList()) {
            ExternalHostSqiGroup sqiGroup = null;
            switch (hostIksInfo.getIksLevel()) {
                case IKS_LEVEL_0_10: sqiGroup = ExternalHostSqiGroup.SQI_LEVEL_0_10; break;
                case IKS_LEVEL_10_20: sqiGroup = ExternalHostSqiGroup.SQI_LEVEL_10_20; break;
                case IKS_LEVEL_20_50: sqiGroup = ExternalHostSqiGroup.SQI_LEVEL_20_50; break;
                case IKS_LEVEL_50_100: sqiGroup = ExternalHostSqiGroup.SQI_LEVEL_50_100; break;
                case IKS_LEVEL_100_250: sqiGroup = ExternalHostSqiGroup.SQI_LEVEL_100_250; break;
                case IKS_LEVEL_250_500: sqiGroup = ExternalHostSqiGroup.SQI_LEVEL_250_500; break;
                case IKS_LEVEL_500_1000: sqiGroup = ExternalHostSqiGroup.SQI_LEVEL_500_1000; break;
                case IKS_LEVEL_1000_INF: sqiGroup = ExternalHostSqiGroup.SQI_LEVEL_1000_INF; break;
            }
            long count = hostIksInfo.getCount();
            if (sqiGroup != null) {
                externalHostsSqi.put(sqiGroup, count);
            }
        }

        for (Links.LinkHttpInfo linkHttpInfo : linksInfo.getInternalLinksHttpCodesList()) {
            internalLinksHttpCodes.put(linkHttpInfo.getHttpCode(), linkHttpInfo.getCount());
        }

        for (Links.LinkHttpInfo linkHttpInfo : linksInfo.getExternalLinksHttpCodesList()) {
            externalLinksHttpCodes.put(linkHttpInfo.getHttpCode(), linkHttpInfo.getCount());
        }

        for (Links.TldInfo tldInfo : linksInfo.getExternalLinksTldCountList()) {
            externalLinksTldCount.put(tldInfo.getTldName(), tldInfo.getCount());
        }

        for (Links.HostIksCounterInfo hostIksCounterInfo : linksInfo.getExternalHostsIksCountersList()) {
            externalDetailedSqiCount.put(hostIksCounterInfo.getIks(), hostIksCounterInfo.getCount());
        }

        return new HostLinkStatistics(
                hostId, linkGeneratuionUUID,
                preparatCurrentTimestamp, preparatPreviousTimestamp,
                linksInfo.getExternalLinksCount(),
                linksInfo.getExternalHostsCount(),
                linksInfo.getNewExternalLinksCount(),
                linksInfo.getNewExternalHostsCount(),
                linksInfo.getGoneExternalLinksCount(),
                linksInfo.getGoneExternalHostsCount(),
                linksInfo.getInternalLinksCount(),
                externalHostsSqi,
                externalDetailedSqiCount,
                internalLinksHttpCodes,
                externalLinksHttpCodes,
                externalLinksTldCount
        );
    }
}
