package ru.yandex.webmaster3.core.proto.converter;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.checklist.data.HostMicrodataStats;
import ru.yandex.webmaster3.core.checklist.data.MicrodataDocStatus;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.proto.Semantic;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;

/**
 * @author avhaliullin
 */
public class MicrodataStatsConverter {
    public static HostMicrodataStats convertFromProto(Semantic.HostReportInfo message, Collection<MicrodataDocStatus> examplesForStatuses) {
        EnumMap<MicrodataDocStatus, Long> counts = new EnumMap<>(MicrodataDocStatus.class);
        for (Semantic.ResultCountInfo countInfo : message.getResultsList()) {
            MicrodataDocStatus status;
            switch (countInfo.getStatus()) {
                case ABORTED:
                    status = MicrodataDocStatus.ABORTED;
                    break;
                case INVALID:
                    status = MicrodataDocStatus.INVALID;
                    break;
                case NO_MARKUP:
                    status = MicrodataDocStatus.NO_MARKUP;
                    break;
                case VALID:
                    status = MicrodataDocStatus.VALID;
                    break;
                case WARNING:
                    status = MicrodataDocStatus.WARNING;
                    break;
                case YANDEX_INVALID:
                    status = MicrodataDocStatus.YANDEX_INVALID;
                    break;
                default:
                    throw new WebmasterException("Unknown doc microdata status " + countInfo.getStatus(),
                            new WebmasterErrorResponse.InternalUnknownErrorResponse(MicrodataStatsConverter.class, null));
            }
            counts.put(status, countInfo.getCount());
        }
        EnumMap<MicrodataDocStatus, List<String>> examplesMap = new EnumMap<>(MicrodataDocStatus.class);
        for (MicrodataDocStatus status : examplesForStatuses) {
            List<String> examples;
            switch (status) {
                case ABORTED:
                    examples = message.getUrlsExamplesAbortedList();
                    break;
                case INVALID:
                    examples = message.getUrlsExamplesInvalidList();
                    break;
                case WARNING:
                    examples = message.getUrlsExamplesWarningList();
                    break;
                case YANDEX_INVALID:
                    examples = message.getUrlsExamplesYandexInvalidList();
                    break;
                case NO_MARKUP:
                case VALID:
                default:
                    examples = Collections.emptyList();
            }
            examplesMap.put(status, examples);
        }

        return new HostMicrodataStats(counts, examplesMap);

    }

}
