package ru.yandex.webmaster3.core.proto.converter;

import NWebmaster.proto.urltree.Exported;
import ru.yandex.webmaster3.core.host.RobotsTxtExportInfo;

/**
 * @author avhaliullin
 */
public class RobotsTxtProtoConverter {
    public static RobotsTxtExportInfo getRobotsTxtInfo(Exported.RobotsTxtInfo info) {
        if (!info.hasHttpCode()) {
            return null;
        }
        return new RobotsTxtExportInfo(
                info.getParsed().hasHost() ? info.getParsed().getHost() : null,
                info.getHttpCode() == 200,
                info.getErrorsCount() > 0,
                info.getWarningsCount() > 0,
                info.getParsed().hasHost2NdLevel() ? info.getParsed().getHost2NdLevel() : null,
                info.getParsed().getHost2NdLevelFoundInDb()
        );
    }
}
