package ru.yandex.webmaster3.core.proto.converter;

import NWebmaster.proto.urltree.Exported;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WhoisInfo;

/**
 * @author avhaliullin
 */
public class WhoisDataProtoConverter {
    public static WhoisInfo getWhoisInfo(Exported.WhoisMessage whoisMessage) {
        DateTime informationDate = null;
        if (whoisMessage.hasTimeVerisign()) {
            informationDate = ConverterUtils.toDateTime(whoisMessage.getTimeVerisign());
        } else if (whoisMessage.hasTimeParsed()) {
            informationDate = ConverterUtils.toDateTime(whoisMessage.getTimeParsed());
        }
        DateTime expirationDate = null;
        if (whoisMessage.hasTimeExpired()) {
            expirationDate = ConverterUtils.toDateTime(whoisMessage.getTimeExpired());
        }
        return new WhoisInfo(expirationDate, informationDate, whoisMessage.getFound() != Exported.WhoisMessage.FoundState.NOT_FOUND);
    }
}
