package ru.yandex.webmaster3.core.regions.data;

/**
 * @author avhaliullin
 */
public class HostRegion {
    private final int regionId;
    private final HostRegionSourceTypeEnum sourceType;

    public HostRegion(int regionId, HostRegionSourceTypeEnum sourceType) {
        this.regionId = regionId;
        this.sourceType = sourceType;
    }

    public int getRegionId() {
        return regionId;
    }

    public HostRegionSourceTypeEnum getSourceType() {
        return sourceType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        HostRegion that = (HostRegion) o;

        if (regionId != that.regionId) return false;
        if (sourceType != that.sourceType) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = regionId;
        result = 31 * result + sourceType.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "HostRegion{" +
                "regionId=" + regionId +
                ", sourceType=" + sourceType +
                '}';
    }
}
