package ru.yandex.webmaster3.core.regions.data;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author avhaliullin
 */
public enum HostRegionSourceTypeEnum implements IntEnum {
    CATALOG(0),
    DICTIONARY(1),
    WEBMASTER(2),
    AUTOCLASSIFIER(3);

    private final int value;

    HostRegionSourceTypeEnum(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<HostRegionSourceTypeEnum> R = IntEnumResolver.r(HostRegionSourceTypeEnum.class);
}
