package ru.yandex.webmaster3.core.review;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;

/**
 * @author: ishalaru
 * DATE: 19.07.2019
 */
@Value
@Builder
@AllArgsConstructor
public class SendReviewComplaintEMailTaskData extends WorkerTaskData {
    WebmasterHostId hostId;
    long userId;
    String reviewId;
    String reviewText;
    DateTime reviewTime;
    Long reviewUserId;
    String complaintText;
    DateTime complaintTime;

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.SEND_REVIEW_COMPLAIN_EMAIL;
    }

    @Override
    public String getShortDescription() {
        return "email about complaint on review to support";
    }
}
