package ru.yandex.webmaster3.core.robotstxt;

import java.util.List;

/**
 * @author avhaliullin
 */
public class AnalysisResult {
    private final List<ErrorInfo> errors;
    private final List<Long> acceptedLines;
    private final List<AllowInfo> areAllowed;

    public AnalysisResult(List<ErrorInfo> errors, List<Long> acceptedLines,
            List<AllowInfo> areAllowed) {
        this.errors = errors;
        this.acceptedLines = acceptedLines;
        this.areAllowed = areAllowed;
    }

    public List<ErrorInfo> getErrors() {
        return errors;
    }

    public List<Long> getAcceptedLines() {
        return acceptedLines;
    }

    public List<AllowInfo> getAreAllowed() {
        return areAllowed;
    }
}
