package ru.yandex.webmaster3.core.sanctions;

import org.joda.time.Instant;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.Set;

/**
 * Created by ifilippov5 on 23.08.17.
 */
public class SanctionsRecheckRequested {
    private final Instant date;
    private final Long userId;
    private final WebmasterHostId hostId;
    private final Set<String> sanctions;

    public SanctionsRecheckRequested(
            Instant date,
            Long userId,
            WebmasterHostId hostId,
            Set<String> sanctions) {
        this.date = date;
        this.userId = userId;
        this.hostId = hostId;
        this.sanctions = sanctions;
    }

    public Instant getDate() {
        return date;
    }

    public Long getUserId() {
        return userId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public Set<String> getSanctions() {
        return sanctions;
    }

    public static SanctionsRecheckRequested create(Long userId, WebmasterHostId hostId, Set<String> sanctions) {
        return new SanctionsRecheckRequested(Instant.now(), userId, hostId, sanctions);
    }

    public static SanctionsRecheckRequested create(Instant date, Long userId, WebmasterHostId hostId, Set<String> sanctions) {
        return new SanctionsRecheckRequested(date, userId, hostId, sanctions);
    }
}
