package ru.yandex.webmaster3.core.searchbase;

import org.joda.time.Instant;
import ru.yandex.webmaster3.core.util.MapUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.TreeMap;

/**
 * @author avhaliullin
 */
public class SearchBaseDates {
    private final NavigableMap<Instant, SearchBaseUpdateInfo> collectionDate2Info;
    private final NavigableMap<Instant, SearchBaseUpdateInfo> switchDate2Info;

    private SearchBaseDates(NavigableMap<Instant, SearchBaseUpdateInfo> collectionDate2Info, NavigableMap<Instant, SearchBaseUpdateInfo> switchDate2Info) {
        this.collectionDate2Info = collectionDate2Info;
        this.switchDate2Info = switchDate2Info;
    }

    public NavigableMap<Instant, SearchBaseUpdateInfo> getCollectionDate2Info() {
        return collectionDate2Info;
    }

    public NavigableMap<Instant, SearchBaseUpdateInfo> getSwitchDate2Info() {
        return switchDate2Info;
    }

    public SearchBaseUpdateInfo getCurrentBase() {
        return switchDate2Info.lastEntry().getValue();
    }

    /**
     * Возвращает знание о переключении поисковых баз на заданный момент времени в прошлом
     */
    public SearchBaseDates atMomentOfTime(Instant instant) {
        NavigableMap<Instant, SearchBaseUpdateInfo> newSwitch2Info = MapUtils.headMap(switchDate2Info, instant, true);
        if (newSwitch2Info.size() != switchDate2Info.size()) {
            TreeMap<Instant, SearchBaseUpdateInfo> newCollectionDate2Info = new TreeMap<>();
            for (SearchBaseUpdateInfo info : newSwitch2Info.values()) {
                newCollectionDate2Info.put(info.getBaseCollectionDate(), info);
            }
            return new SearchBaseDates(
                    Collections.unmodifiableNavigableMap(newCollectionDate2Info),
                    Collections.unmodifiableNavigableMap(newSwitch2Info)
            );
        } else {
            return this;
        }
    }

    public static SearchBaseDates fromBaseInfos(Collection<SearchBaseUpdateInfo> infos) {
        TreeMap<Instant, SearchBaseUpdateInfo> collectionDate2Info = new TreeMap<>();
        TreeMap<Instant, SearchBaseUpdateInfo> switchDate2Info = new TreeMap<>();
        for (SearchBaseUpdateInfo updateInfo : infos) {
            collectionDate2Info.put(updateInfo.getBaseCollectionDate(), updateInfo);
            switchDate2Info.put(updateInfo.getBaseSwitchDate(), updateInfo);
        }
        return new SearchBaseDates(
                Collections.unmodifiableNavigableMap(collectionDate2Info),
                Collections.unmodifiableNavigableMap(switchDate2Info)
        );
    }
}
