package ru.yandex.webmaster3.core.searchbase;

import org.joda.time.Instant;

/**
 * @author avhaliullin
 */
public class SearchBaseSwitchUtil {
    public static <T> T selectDoubleSourcedData(T curBaseData, T nextBaseData, Instant nextBaseDate,
                                                SearchBaseDates searchBaseDates, Instant now) {
        if (nextBaseDate == null || nextBaseData == null) {
            return curBaseData;
        }
        SearchBaseUpdateInfo updateInfo = searchBaseDates.getCollectionDate2Info().get(nextBaseDate);
        if (updateInfo != null && !now.isBefore(updateInfo.getBaseSwitchDate())) {
            return nextBaseData;
        } else {
            return curBaseData;
        }
    }
}
