package ru.yandex.webmaster3.core.searchbase;

import org.joda.time.Instant;

/**
 * @author avhaliullin
 */
public class SearchBaseUpdateInfo {
    private final Instant baseSwitchDate;
    private final Instant baseCollectionDate;

    public SearchBaseUpdateInfo(Instant baseSwitchDate, Instant baseCollectionDate) {
        this.baseSwitchDate = baseSwitchDate;
        this.baseCollectionDate = baseCollectionDate;
    }

    public Instant getBaseSwitchDate() {
        return baseSwitchDate;
    }

    public Instant getBaseCollectionDate() {
        return baseCollectionDate;
    }

    @Override
    public String toString() {
        return "SearchBaseUpdateInfo{" +
                "switchDate=" + baseSwitchDate +
                ", collectionDate=" + baseCollectionDate +
                '}';
    }
}
