package ru.yandex.webmaster3.core.searchquery;

/**
 * @author aherman
 */
public class LatestSearchQuery {
    private final QueryId queryId;
    private final String url;
    private final double totalShowsCount;
    private final double totalClicksCount;
    private final double ctrTotal;
    private final double avgShowPosition;
    private final double avgClickosition;

    public LatestSearchQuery(QueryId queryId, String url, double totalShowsCount, double totalClicksCount, double ctrTotal, double avgShowPosition, double avgClickosition) {
        this.queryId = queryId;
        this.url = url;
        this.totalShowsCount = totalShowsCount;
        this.totalClicksCount = totalClicksCount;
        this.ctrTotal = ctrTotal;
        this.avgShowPosition = avgShowPosition;
        this.avgClickosition = avgClickosition;
    }

    public QueryId getQueryId() {
        return queryId;
    }

    public String getUrl() {
        return url;
    }

    public double getTotalShowsCount() {
        return totalShowsCount;
    }

    public double getTotalClicksCount() {
        return totalClicksCount;
    }

    public double getCtrTotal() {
        return ctrTotal;
    }

    public double getAvgShowPosition() {
        return avgShowPosition;
    }

    public double getAvgClickosition() {
        return avgClickosition;
    }
}
