package ru.yandex.webmaster3.core.searchquery;

import ru.yandex.autodoc.common.util.enums.IEnumResolver;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum OrderDirection implements IntEnum{
    ASC(1),
    DESC(2);

    private final int value;

    OrderDirection(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public OrderDirection reverse() {
        if (this == ASC) {
            return DESC;
        }
        return ASC;
    }

    public static IntEnumResolver<OrderDirection> R = IntEnumResolver.r(OrderDirection.class);
}
