package ru.yandex.webmaster3.core.searchquery;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author lester
 */
public class Path {
    public static int MAX_LENGTH = 100;

    private final WebmasterHostId hostId;
    private final PathId pathId;
    private final String path;

    public Path(WebmasterHostId hostId, PathId pathId, String path) {
        this.hostId = hostId;
        this.pathId = pathId;
        this.path = path;
    }

    public Path(WebmasterHostId hostId, String path) {
        this.hostId = hostId;
        this.pathId = PathId.textToId(path);
        this.path = path;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public PathId getPathId() {
        return pathId;
    }

    public String getPath() {
        return path;
    }
}
