package ru.yandex.webmaster3.core.searchquery;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author tsyplyaev
 */
public class Query {
    public static int MAX_LENGTH = 100;

    private final WebmasterHostId hostId;
    private final QueryId queryId;
    private final String query;

    public Query(WebmasterHostId hostId, QueryId queryId, String query) {
        this.hostId = hostId;
        this.queryId = queryId;
        this.query = query;
    }

    public Query(WebmasterHostId hostId, String query) {
        this.hostId = hostId;
        this.queryId = QueryId.textToId(query);
        this.query = query;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public QueryId getQueryId() {
        return queryId;
    }

    public String getQuery() {
        return query;
    }
}
