package ru.yandex.webmaster3.core.searchquery;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public class QueryFilter {
    private QueryIndicator indicator;
    private Operation operation;
    private float numberValue;
    private String text;

    public QueryFilter() {
    }

    public QueryFilter(
            @JsonProperty("indicator") QueryIndicator indicator,
            @JsonProperty("operation") Operation operation,
            @JsonProperty("numberValue") float numberValue,
            @JsonProperty("textValue") String textValue)
    {
        this.indicator = indicator;
        this.operation = operation;
        this.numberValue = numberValue;
        this.text = textValue;
    }

    public QueryIndicator getIndicator() {
        return indicator;
    }

    public Operation getOperation() {
        return operation;
    }

    public float getNumberValue() {
        return numberValue;
    }

    public String getText() {
        return text;
    }

    public void setIndicator(QueryIndicator indicator) {
        this.indicator = indicator;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public void setNumberValue(float numberValue) {
        this.numberValue = numberValue;
    }

    public void setText(String text) {
        this.text = text;
    }

    public QueryFilter withText(String text){
        return new QueryFilter(indicator, operation, numberValue, text);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        QueryFilter that = (QueryFilter) o;

        if (Float.compare(that.numberValue, numberValue) != 0) {
            return false;
        }
        if (indicator != that.indicator) {
            return false;
        }
        if (operation != that.operation) {
            return false;
        }
        return !(text != null ? !text.equals(that.text) : that.text != null);

    }

    @Override
    public int hashCode() {
        int result = indicator != null ? indicator.hashCode() : 0;
        result = 31 * result + (operation != null ? operation.hashCode() : 0);
        result = 31 * result + (numberValue != +0.0f ? Float.floatToIntBits(numberValue) : 0);
        result = 31 * result + (text != null ? text.hashCode() : 0);
        return result;
    }

    public static enum Operation implements IntEnum {
        UNKNOWN(        0, false),

        LESS_THAN(      1, false),
        LESS_EQUAL(     2, false),
        GREATER_THAN(   3, false),
        GREATER_EQUAL(  4, false),

        TEXT_CONTAINS(  20, true),
        ;

        private final int value;
        private final boolean textOperation;

        private Operation(int value, boolean textOperation) {
            this.value = value;
            this.textOperation = textOperation;
        }

        @Override
        public int value() {
            return value;
        }

        public boolean isTextOperation() {
            return textOperation;
        }

        public static final IntEnumResolver<Operation> R = IntEnumResolver.r(Operation.class);
    }
}
