package ru.yandex.webmaster3.core.searchquery;

import java.util.List;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Instant;

/**
 * @author aherman
 */
public class QueryGroup {
    public static final int GROUP_LIMIT = 100;
    public static final int QUERY_LIMIT = 500;

    private final QueryGroupId groupId;
    private final String name;
    private final boolean hasQueries;
    private final Instant createDate;
    private final Instant updateDate;
    private final SpecialGroup specialGroup;

    private final List<QueryFilter> filters;

    public QueryGroup(QueryGroupId groupId, String name, boolean hasQueries, SpecialGroup specialGroup)
    {
        this.groupId = groupId;
        this.name = name;
        this.hasQueries = hasQueries;
        this.createDate = null;
        this.updateDate = null;
        this.filters = null;
        this.specialGroup = specialGroup;
    }

    public QueryGroup(QueryGroupId groupId, String name, boolean hasQueries, List<QueryFilter> filters, Instant createDate,
            Instant updateDate)
    {
        this.groupId = groupId;
        this.name = name;
        this.hasQueries = hasQueries;
        this.createDate = createDate;
        this.updateDate = updateDate;
        this.filters = filters;
        this.specialGroup = null;
    }

    @JsonIgnore
    public QueryGroupId getQueryGroupId() {
        return groupId;
    }

    public UUID getGroupId() {
        return groupId.getGroupId();
    }

    public boolean isHasQueries() {
        return hasQueries;
    }

    public String getName() {
        return name;
    }

    @Nullable
    public Instant getCreateDate() {
        return createDate;
    }

    @Nullable
    public Instant getUpdateDate() {
        return updateDate;
    }

    @Nullable
    public List<QueryFilter> getFilters() {
        return filters;
    }

    public SpecialGroup getSpecialGroup() {
        return specialGroup;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        QueryGroup that = (QueryGroup) o;

        if (!groupId.equals(that.groupId)) {
            return false;
        }
        return specialGroup == that.specialGroup;
    }

    @Override
    public int hashCode() {
        int result = groupId.hashCode();
        result = 31 * result + specialGroup.hashCode();
        return result;
    }
}
