package ru.yandex.webmaster3.core.searchquery;

import java.util.Objects;
import java.util.UUID;

import com.datastax.driver.core.utils.UUIDs;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum SpecialGroup implements IntEnum {
    UNKNOWN(0),

    ALL_QUERIES(1), // 13816710-1dd2-11b2-8080-808080808080
    UPLOADED_QUERIES(2, 10000), // 13818e20-1dd2-11b2-8080-808080808080
    SELECTED_QUERIES(3, 1000), // 1381b530-1dd2-11b2-8080-808080808080
    TOP_3000_QUERIES(4), // 1381dc40-1dd2-11b2-8080-808080808080
    RIVALS_STATS(5), //13820350-1dd2-11b2-8080-808080808080
    TOP_URLS(6), //13822a60-1dd2-11b2-8080-808080808080
    ;

    public static EnumResolver<SpecialGroup> R = EnumResolver.er(SpecialGroup.class);
    public static IntEnumResolver<SpecialGroup> INT_RESOLVER = IntEnumResolver.r(SpecialGroup.class);

    private final UUID groupId;
    private final Integer limit;
    private final Integer id;

    SpecialGroup(int id) {
        this.groupId = UUIDs.startOf(id);
        this.limit = null;
        this.id = id;
    }

    SpecialGroup(int id, int limit) {
        this.groupId = UUIDs.startOf(id);
        this.limit = limit;
        this.id = id;
    }

    public UUID getGroupId() {
        return groupId;
    }

    public Integer getLimit() {
        return limit;
    }

    public static SpecialGroup byUUID(UUID uuid) {
        for (SpecialGroup specialGroup : values()) {
            if (Objects.equals(specialGroup.groupId, uuid)) {
                return specialGroup;
            }
        }
        return UNKNOWN;
    }

    @Override
    public int value() {
        return id;
    }
}
