package ru.yandex.webmaster3.core.searchquery.history;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.searchquery.QueryFilter;
import ru.yandex.webmaster3.core.searchquery.viewer.QueryFilterConverter;
import ru.yandex.webmaster3.core.searchquery.viewer.ViewerQueryFilter;

import java.util.List;

/**
 * @author tsyplyaev
 */
public class GroupFilterChanged extends GroupModification {
    private List<QueryFilter> oldFilter;
    private List<QueryFilter> newFilter;

    public GroupFilterChanged() {
        super(ModificationType.GROUP_FILTER_CHANGED);
    }

    public GroupFilterChanged(@JsonProperty List<QueryFilter> oldFilter, @JsonProperty List<QueryFilter> newFilter) {
        super(ModificationType.GROUP_FILTER_CHANGED);
        this.oldFilter = oldFilter;
        this.newFilter = newFilter;
    }

    /*
    public List<QueryFilter> getOldFilter() {
        return oldFilter;
    }

    public List<QueryFilter> getNewFilter() {
        return newFilter;
    }*/
    public List<ViewerQueryFilter> getOldFilter() {
        if (oldFilter == null) {
            return null;
        }
        return QueryFilterConverter.toViewerFilter(oldFilter);
    }

    public List<ViewerQueryFilter> getNewFilter() {
        if (newFilter == null) {
            return null;
        }
        return QueryFilterConverter.toViewerFilter(newFilter);
    }

    public void setOldFilter(List<QueryFilter> oldFilter) {
        this.oldFilter = oldFilter;
    }

    public void setNewFilter(List<QueryFilter> newFilter) {
        this.newFilter = newFilter;
    }
}
