package ru.yandex.webmaster3.core.searchquery.history;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author tsyplyaev
 */
public enum ModificationType implements IntEnum {
    GROUP_FILTER_CHANGED(0, GroupFilterChanged.class),
    GROUP_RENAMED(1, GroupRenamed.class),
    QUERIES_ADDED(2, QueriesAdded.class),
    QUERIES_REMOVED(3, QueriesRemoved.class);

    private final int value;
    public final Class<? extends GroupModification> modificationClass;

    ModificationType(int value, Class<? extends GroupModification> modificationClass) {
        this.value = value;
        this.modificationClass = modificationClass;
    }

    public Class<? extends GroupModification> getModificationClass() {
        return modificationClass;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<ModificationType> R = IntEnumResolver.r(ModificationType.class);
}
