package ru.yandex.webmaster3.core.searchquery.history;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

import ru.yandex.webmaster3.core.searchquery.Query;
import ru.yandex.webmaster3.core.searchquery.QueryFilter;
import ru.yandex.webmaster3.core.searchquery.QueryGroup;
import ru.yandex.webmaster3.core.searchquery.QueryGroupId;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author aherman
 */
@Getter
@Setter
public class QueryGroupState {
    public static final int LIMIT = 100;

    private QueryGroupId groupId;
    private String name;
    private List<QueryFilter> filters;
    private Set<String> queries;

    public QueryGroupState(QueryGroup queryGroup, Set<Query> queries) {
        this.groupId = queryGroup.getQueryGroupId();
        this.name = queryGroup.getName();
        this.filters = queryGroup.getFilters();
        this.queries = queries.stream().map(Query::getQuery).collect(Collectors.toSet());
    }

    public QueryGroupState(QueryGroupId groupId, Set<Query> queries) {
        this.groupId = groupId;
        this.name = null;
        this.filters = null;
        this.queries = queries.stream().map(Query::getQuery).collect(Collectors.toSet());
    }

    @JsonIgnore
    public QueryGroupId getGroupId() {
        return groupId;
    }
}
