package ru.yandex.webmaster3.core.searchquery.viewer;

import java.util.UUID;

import org.joda.time.DateTimeZone;

import ru.yandex.webmaster3.core.searchquery.QueryGroup;
import ru.yandex.webmaster3.core.searchquery.SpecialGroup;

/**
 * @author aherman
 */
public class QueryGroupConverter {
    public static ViewerQueryGroup toViewerGroup(QueryGroup queryGroup) {
        UUID groupId;
        groupId = queryGroup.getGroupId();
        return new ViewerQueryGroup(
                groupId.toString(),
                queryGroup.getName(),
                queryGroup.getSpecialGroup(),
                queryGroup.getFilters() != null ? QueryFilterConverter.toViewerFilter(queryGroup.getFilters()) : null,
                0,
                queryGroup.getCreateDate() != null ? queryGroup.getCreateDate().toDateTime(DateTimeZone.UTC) : null,
                queryGroup.getUpdateDate() != null ? queryGroup.getUpdateDate().toDateTime(DateTimeZone.UTC) : null
        );
    }

    public static ViewerQueryGroup toViewerGroup(SpecialGroup specialGroup) {
        String name = null;
        String id = specialGroup.name();

        return new ViewerQueryGroup(
                id,
                name,
                specialGroup,
                null,
                0,
                null,
                null
        );
    }
}
