package ru.yandex.webmaster3.core.searchquery.viewer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import ru.yandex.webmaster3.core.searchquery.PathId;

/**
 * @author lester
 */
public class ViewerPath {
    private final PathId pathId;
    private final String text;

    public ViewerPath(PathId pathId, String text) {
        this.pathId = pathId;
        this.text = text;
    }

    public String getPathId() {
        return pathId.toStringId();
    }

    public String getText() {
        return text;
    }

    @JsonIgnore
    public PathId getId() {
        return pathId;
    }
}
