package ru.yandex.webmaster3.core.searchquery.viewer;

import com.fasterxml.jackson.annotation.JsonIgnore;

import ru.yandex.webmaster3.core.searchquery.QueryId;

/**
 * @author aherman
 */
public class ViewerQuery {
    private final QueryId queryId;
    private final String text;

    public ViewerQuery(QueryId queryId, String text) {
        this.queryId = queryId;
        this.text = text;
    }

    public String getQueryId() {
        return queryId.toStringId();
    }

    public String getText() {
        return text;
    }

    @JsonIgnore
    public QueryId getId() {
        return queryId;
    }
}
