package ru.yandex.webmaster3.core.searchquery.viewer;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.webmaster3.core.searchquery.QueryIndicator;

/**
 * @author aherman
 */
public class ViewerQueryFilter {
    private final QueryIndicator indicator;
    private final Operation operation;
    private final String value;

    public ViewerQueryFilter(
            @JsonProperty("indicator") QueryIndicator indicator,
            @JsonProperty("operation") Operation operation,
            @JsonProperty("value") String value)
    {
        this.indicator = indicator;
        this.operation = operation;
        this.value = value;
    }

    public QueryIndicator getIndicator() {
        return indicator;
    }

    public Operation getOperation() {
        return operation;
    }

    public String getValue() {
        return value;
    }

    public static enum Operation {
        LESS_THAN,
        LESS_EQUAL,
        GREATER_THAN,
        GREATER_EQUAL,

        TEXT_CONTAINS,
    }
}
