package ru.yandex.webmaster3.core.searchquery.viewer;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;

import com.google.common.collect.ImmutableMap;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.searchquery.SpecialGroup;

/**
 * @author aherman
 */
public class ViewerQueryGroup {
    private final String groupId;
    private final String name;
    private final SpecialGroup specialGroup;
    private final List<ViewerQueryFilter> filters;
    private final int userQueriesCount;
    private final DateTime createDate;
    private final DateTime updateDate;

    public ViewerQueryGroup(String groupId,
            String name,
            SpecialGroup specialGroup,
            List<ViewerQueryFilter> filters,
            int userQueriesCount,
            DateTime createDate,
            DateTime updateDate)
    {
        this.groupId = groupId;
        this.name = name;
        this.specialGroup = specialGroup;
        this.filters = filters;
        this.userQueriesCount = userQueriesCount;
        this.createDate = createDate;
        this.updateDate = updateDate;
    }

    public String getGroupId() {
        return groupId;
    }

    public String getName() {
        return name;
    }

    public SpecialGroup getSpecialGroup() {
        return specialGroup;
    }

    public List<ViewerQueryFilter> getFilters() {
        return filters;
    }

    public int getUserQueriesCount() {
        return userQueriesCount;
    }

    public DateTime getCreateDate() {
        return createDate;
    }

    public DateTime getUpdateDate() {
        return updateDate;
    }

    private static final EnumMap<SpecialGroup, Integer> SPECIAL_GROUPS_ORDER = new EnumMap<>(ImmutableMap.of(
            SpecialGroup.ALL_QUERIES, 0,
            SpecialGroup.TOP_3000_QUERIES, 1,
            SpecialGroup.SELECTED_QUERIES, 2,
            SpecialGroup.RIVALS_STATS, 3
    ));

    public static final Comparator<ViewerQueryGroup> SPECIAL_GROUPS_FIRST = (g1, g2) -> {
        int order1 = SPECIAL_GROUPS_ORDER.getOrDefault(g1.specialGroup, Integer.MAX_VALUE);
        int order2 = SPECIAL_GROUPS_ORDER.getOrDefault(g2.specialGroup, Integer.MAX_VALUE);
        return Integer.compare(order1, order2);
    };

}
