package ru.yandex.webmaster3.core.security;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/**
 * User: azakharov
 * Date: 25.03.15
 * Time: 18:02
 */
public class InfectedUrlData extends WarningUrlData {
    private final String virusName;
    private final List<String> urlsChain;
    private final boolean showVerdict;

    public InfectedUrlData(String url, DateTime lastCheck, String name, boolean showVerdict, List<String> urlsChain) {
        super(url, lastCheck);
        this.showVerdict = showVerdict;
        this.virusName = showVerdict ? name : null;
        this.urlsChain = urlsChain;
    }

    @Nullable
    public String getVirusName() {
        return showVerdict ? virusName : null;
    }

    @JsonIgnore
    public String getVirusNameInternal() {
        return virusName;
    }

    public List<String> getUrlsChain() {
        return urlsChain;
    }

    public boolean isShowVerdict() {
        return showVerdict;
    }
}
