package ru.yandex.webmaster3.core.semantic.data_reactor_common;

import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.EntityAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.impl.attrs.StringAttrValue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import static ru.yandex.common.util.StringUtils.isEmpty;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11.12.13
 * Time: 16:47
 */
public abstract class Entity {

    public final String tag;

    public final String url;

    protected Entity(String tag, String url) {
        this.tag = tag;
        this.url = url;
    }


    public String getTag() {
        return tag;
    }

    public String getUrl() {
        return url;
    }

    public abstract Set<String> getAttributes();

    public abstract List<BaseAttrValue> getValues(String attrName);

    public boolean containAttribute(String attrName) {
        return !this.getValues(attrName).isEmpty();
    }

    public BaseAttrValue getFirstOrNull(String attrName) {
        if (getValues(attrName).size() > 0) {
            return getValues(attrName).get(0);
        } else {
            return null;
        }
    }

    public String getStringValue(String name) {
        for (BaseAttrValue attribute : this.getValues(name)) {
            if (attribute instanceof StringAttrValue) {
                if (!isEmpty(((StringAttrValue) attribute).getContent())) {
                    return ((StringAttrValue) attribute).getContent();
                }
            } else if (attribute instanceof EntityAttrValue) {
                if (((EntityAttrValue) attribute).entity.containAttribute("data")) {
                    return ((EntityAttrValue) attribute).entity.getStringValue("data");
                }
            }
        }
        return null;
    }

    public Entity getEntityValue(String name) {
        if (this.getFirstOrNull(name) instanceof EntityAttrValue) {
            return ((EntityAttrValue) this.getFirstOrNull(name)).entity;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public List<String> getStringValues(String name) {
        ArrayList<String> values = new ArrayList<>();
        for (BaseAttrValue attr : this.getValues(name)) {
            if (attr instanceof StringAttrValue) {
                values.add(((StringAttrValue) attr).getContent());
            }
        }
        return values;
    }

    public abstract void setValues(String attrName, Collection<BaseAttrValue> values);

    public abstract void setValue(String attrName, BaseAttrValue value);

    public abstract void appendValue(String attrName, BaseAttrValue value);
}
