package ru.yandex.webmaster3.core.semantic.data_reactor_common.impl;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.collections.MultiMap;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.BaseAttrValue;
import ru.yandex.webmaster3.core.semantic.data_reactor_common.Entity;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11.12.13
 * Time: 17:13
 */
public class BaseMutableEntity extends Entity {

    public BaseMutableEntity(String tag,String url) {
        super(tag,url);
    }
    public BaseMutableEntity(Entity e){
        super(e.getTag(),e.getUrl());
        for(String attr : e.getAttributes()){
            attrMap.put(attr, e.getValues(attr));
        }
    }
    public BaseMutableEntity(Entity e,String newTag){
        super(newTag,e.getUrl());
        for(String attr : e.getAttributes()){
            attrMap.put(attr, e.getValues(attr));
        }
    }

    final MultiMap<String, BaseAttrValue> attrMap = new MultiMap<>();

    @Override
    public Set<String> getAttributes() {
        return attrMap.keySet();
    }

    @Override
    public List<BaseAttrValue> getValues(final String attrName) {
        if(attrMap.get(attrName)!=null){
            return Collections.unmodifiableList(attrMap.get(attrName));
        }else{
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public void setValues(final String attrName, final Collection<BaseAttrValue> values) {
        attrMap.put(attrName, Cf.list(values));
    }

    @Override
    public void setValue(final String attrName, final BaseAttrValue value) {
        attrMap.put(attrName, Cf.list(value));
    }

    @Override
    public void appendValue(final String attrName, final BaseAttrValue value) {
        if(value != null){
            attrMap.append(attrName, value);
        }
    }
    public void clearAttribute(final String attrName){
        attrMap.remove(attrName);
    }
}
